/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class CurseOfHospitalityEffect
extends OneShotEffect {
    CurseOfHospitalityEffect() {
        super(Outcome.Benefit);
    }

    private CurseOfHospitalityEffect(CurseOfHospitalityEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfHospitalityEffect copy() {
        return new CurseOfHospitalityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return false;
        }
        Player enchanted = game.getPlayer(permanent.getAttachedTo());
        if (enchanted == null) {
            return false;
        }
        Card card = enchanted.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        enchanted.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return true;
        }
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)true, (UUID)player.getId(), null);
        return true;
    }
}

