/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class CurseOfTheCabalTriggeredAbilityConditionalDelay
extends AddCountersSourceEffect {
    public CurseOfTheCabalTriggeredAbilityConditionalDelay() {
        super(CounterType.TIME.createInstance(), (DynamicValue)StaticValue.get((int)2), false, true);
        this.staticText = "that player may sacrifice a permanent of their choice. If the player does, put two time counters on this card";
    }

    public boolean apply(Game game, Ability source) {
        UUID activePlayerId = game.getActivePlayerId();
        Player target = game.getPlayer(activePlayerId);
        SacrificeTargetCost cost = new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT);
        if (target == null) {
            return false;
        }
        if (cost.canPay(source, source, activePlayerId, game) && target.chooseUse(Outcome.Sacrifice, "Sacrifice a permanent to delay Curse of the Cabal?", source, game) && cost.pay(source, game, source, activePlayerId, true, null)) {
            return super.apply(game, source);
        }
        return true;
    }

    private CurseOfTheCabalTriggeredAbilityConditionalDelay(CurseOfTheCabalTriggeredAbilityConditionalDelay effect) {
        super((AddCountersSourceEffect)effect);
    }

    public CurseOfTheCabalTriggeredAbilityConditionalDelay copy() {
        return new CurseOfTheCabalTriggeredAbilityConditionalDelay(this);
    }
}

