/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class CursedScrollEffect
extends OneShotEffect {
    CursedScrollEffect() {
        super(Outcome.Neutral);
        this.staticText = ", then reveal a card at random from your hand. If that card has the chosen name, {this} deals 2 damage to any target";
    }

    private CursedScrollEffect(CursedScrollEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (sourceObject != null && controller != null && cardName != null && !cardName.isEmpty()) {
            if (!controller.getHand().isEmpty()) {
                CardsImpl revealed = new CardsImpl();
                Card card = controller.getHand().getRandom(game);
                if (card == null) {
                    return false;
                }
                revealed.add(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)revealed, game);
                if (CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) {
                    Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                    if (creature != null) {
                        creature.damage(2, source.getSourceId(), source, game, false, true);
                        return true;
                    }
                    Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
                    if (player != null) {
                        player.damage(2, source.getSourceId(), source, game);
                        return true;
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public CursedScrollEffect copy() {
        return new CursedScrollEffect(this);
    }
}

