/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.CustodiSquireVote;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CustodiSquireVoteEffect
extends OneShotEffect {
    CustodiSquireVoteEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for an artifact, creature, or enchantment card in your graveyard. Return each card with the most votes or tied for most votes to your hand";
    }

    private CustodiSquireVoteEffect(CustodiSquireVoteEffect effect) {
        super((OneShotEffect)effect);
    }

    public CustodiSquireVoteEffect copy() {
        return new CustodiSquireVoteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CustodiSquireVote vote = new CustodiSquireVote();
        vote.doVotes(source, game);
        return player.moveCards(vote.getMostVoted(), Zone.HAND, source, game);
    }
}

