/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CyberdriveAwakenerEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledArtifactPermanent();

    CyberdriveAwakenerEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "until end of turn, each noncreature artifact you control becomes an artifact creature with base power and toughness 4/4";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private CyberdriveAwakenerEffect(CyberdriveAwakenerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).stream().filter(Objects::nonNull).map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(this.affectedObjectList::add);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        List permanents = this.affectedObjectList.stream().map(mor -> mor.getPermanent(game)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            this.discard();
            return false;
        }
        for (Permanent permanent : permanents) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addCardType(game, new CardType[]{CardType.ARTIFACT, CardType.CREATURE});
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(4);
                    permanent.getToughness().setModifiedBaseValue(4);
                }
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public CyberdriveAwakenerEffect copy() {
        return new CyberdriveAwakenerEffect(this);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

