/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class FightEnchantedTargetEffect
extends OneShotEffect {
    FightEnchantedTargetEffect() {
        super(Outcome.Damage);
        this.staticText = "you may have enchanted creature fight target creature an opponent controls. <i>(Each deals damage equal to its power to the other.)</i>";
    }

    private FightEnchantedTargetEffect(FightEnchantedTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent originalCreature;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && (originalCreature = game.getPermanentOrLKIBattlefield(sourcePermanent.getAttachedTo())) != null) {
            Permanent creature1;
            Permanent enchantedCreature = game.getPermanent(sourcePermanent.getAttachedTo());
            if (((Target)source.getTargets().get(0)).isLegal(source, game) && (creature1 = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget())) != null && enchantedCreature != null && creature1.isCreature(game) && enchantedCreature.isCreature(game)) {
                return enchantedCreature.fight(creature1, source, game);
            }
            if (!game.isSimulation()) {
                game.informPlayers(originalCreature.getLogName() + ": Fighting effect has been fizzled.");
            }
        }
        return false;
    }

    public FightEnchantedTargetEffect copy() {
        return new FightEnchantedTargetEffect(this);
    }
}

