/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class ReleaseSacrificeEffect
extends OneShotEffect {
    ReleaseSacrificeEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player sacrifices an artifact, a creature, an enchantment, a land, and a planeswalker";
    }

    private ReleaseSacrificeEffect(ReleaseSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<UUID> chosen = new ArrayList<UUID>();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            TargetControlledPermanent target1 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledArtifactPermanent(), true);
            TargetControlledPermanent target2 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledCreaturePermanent(), true);
            TargetControlledPermanent target3 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledEnchantmentPermanent(), true);
            TargetControlledPermanent target4 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledLandPermanent(), true);
            TargetControlledPermanent target5 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledPlaneswalkerPermanent(), true);
            if (target1.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target1.isChosen(game) && target1.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target1, source, game);
                }
                Permanent artifact = game.getPermanent(target1.getFirstTarget());
                if (artifact != null) {
                    chosen.add(artifact.getId());
                }
                target1.clearChosen();
            }
            if (target2.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target2.isChosen(game) && target2.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target2, source, game);
                }
                Permanent creature = game.getPermanent(target2.getFirstTarget());
                if (creature != null) {
                    chosen.add(creature.getId());
                }
                target2.clearChosen();
            }
            if (target3.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target3.isChosen(game) && target3.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target3, source, game);
                }
                Permanent enchantment = game.getPermanent(target3.getFirstTarget());
                if (enchantment != null) {
                    chosen.add(enchantment.getId());
                }
                target3.clearChosen();
            }
            if (target4.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target4.isChosen(game) && target4.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target4, source, game);
                }
                Permanent land = game.getPermanent(target4.getFirstTarget());
                if (land != null) {
                    chosen.add(land.getId());
                }
                target4.clearChosen();
            }
            if (!target5.canChoose(player.getId(), source, game)) continue;
            while (player.canRespond() && !target5.isChosen(game) && target5.canChoose(player.getId(), source, game)) {
                player.chooseTarget(Outcome.Benefit, (Target)target5, source, game);
            }
            Permanent planeswalker = game.getPermanent(target5.getFirstTarget());
            if (planeswalker != null) {
                chosen.add(planeswalker.getId());
            }
            target5.clearChosen();
        }
        for (UUID uuid : chosen) {
            Permanent permanent = game.getPermanent(uuid);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }

    public ReleaseSacrificeEffect copy() {
        return new ReleaseSacrificeEffect(this);
    }
}

