/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SearchLibraryPutInGraveyard
extends SearchEffect {
    public SearchLibraryPutInGraveyard() {
        super(new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_CREATURE), Outcome.Neutral);
        this.staticText = "search your library for a creature card, put that card into your graveyard, then shuffle";
    }

    private SearchLibraryPutInGraveyard(SearchLibraryPutInGraveyard effect) {
        super((SearchEffect)effect);
    }

    public SearchLibraryPutInGraveyard copy() {
        return new SearchLibraryPutInGraveyard(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            if (controller.searchLibrary(this.target, source, game) && !this.target.getTargets().isEmpty() && (card = controller.getLibrary().getCard(this.target.getFirstTarget(), game)) != null) {
                controller.moveCards(card, Zone.GRAVEYARD, source, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

