/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UntapAllNonlandsTargetEffect
extends OneShotEffect {
    UntapAllNonlandsTargetEffect() {
        super(Outcome.Untap);
    }

    private UntapAllNonlandsTargetEffect(UntapAllNonlandsTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            for (Permanent nonland : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, player.getId(), game)) {
                nonland.untap(game);
            }
            return true;
        }
        return false;
    }

    public UntapAllNonlandsTargetEffect copy() {
        return new UntapAllNonlandsTargetEffect(this);
    }
}

