/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class CardsDiscardedThisTurnWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfCardsDiscardedThisTurn = new HashMap<UUID, Integer>();

    public CardsDiscardedThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        UUID playerId;
        if (event.getType() == GameEvent.EventType.DISCARDED_CARD && (playerId = event.getPlayerId()) != null) {
            this.amountOfCardsDiscardedThisTurn.put(playerId, this.getAmountCardsDiscarded(playerId) + 1);
        }
    }

    public int getAmountCardsDiscarded(UUID playerId) {
        return this.amountOfCardsDiscardedThisTurn.getOrDefault(playerId, 0);
    }

    public void reset() {
        this.amountOfCardsDiscardedThisTurn.clear();
    }
}

