/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesColorTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChangeColorEffect
extends OneShotEffect {
    ChangeColorEffect() {
        super(Outcome.Neutral);
        this.staticText = "Target permanent becomes the color of your choice until end of turn";
    }

    private ChangeColorEffect(ChangeColorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        Permanent chosen = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player != null && permanent != null) {
            BecomesColorTargetEffect effect = new BecomesColorTargetEffect(null, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(chosen.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public ChangeColorEffect copy() {
        return new ChangeColorEffect(this);
    }
}

