/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpecialAction;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.cards.d.DampingEngine;
import mage.cards.d.DampingEngineIgnoreEffect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class DampingEngineSpecialAction
extends SpecialAction {
    DampingEngineSpecialAction() {
        super(Zone.BATTLEFIELD);
        this.addCost((Cost)new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT));
        this.addEffect((Effect)new DampingEngineIgnoreEffect());
        this.setMayActivate(TargetController.ANY);
        this.setRuleVisible(false);
    }

    private DampingEngineSpecialAction(DampingEngineSpecialAction ability) {
        super((SpecialAction)ability);
    }

    public DampingEngineSpecialAction copy() {
        return new DampingEngineSpecialAction(this);
    }

    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Player player = game.getPlayer(playerId);
        if (player != null && DampingEngine.checkPlayer(player, game) && !DampingEngine.checkValue(player.getId(), (Ability)this, game)) {
            return super.canActivate(playerId, game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    public String getRule() {
        return "";
    }
}

