/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DampingMatrixEffect
extends ReplacementEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent("artifacts and creatures");

    public DampingMatrixEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Activated abilities of artifacts and creatures can't be activated unless they're mana abilities";
    }

    private DampingMatrixEffect(DampingMatrixEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DampingMatrixEffect copy() {
        return new DampingMatrixEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        if (object instanceof Permanent && filter.match((Permanent)object, source.getControllerId(), source, game)) {
            Optional ability = object.getAbilities().get(event.getTargetId());
            return ability.isPresent() && !((Ability)ability.get()).isManaActivatedAbility();
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

