/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DanceOfManyExileTokenEffect
extends OneShotEffect {
    DanceOfManyExileTokenEffect() {
        super(Outcome.Removal);
        this.staticText = "exile the token";
    }

    private DanceOfManyExileTokenEffect(DanceOfManyExileTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List tokenPermanents;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (tokenPermanents = (List)game.getState().getValue(source.getSourceId() + "_token")) != null) {
            CardsImpl cards = new CardsImpl();
            for (Permanent permanent : tokenPermanents) {
                cards.add((Card)permanent);
            }
            controller.moveCards((Cards)cards, Zone.EXILED, source, game);
            return true;
        }
        return false;
    }

    public DanceOfManyExileTokenEffect copy() {
        return new DanceOfManyExileTokenEffect(this);
    }
}

