/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DanceWithCalamityEffect
extends OneShotEffect {
    DanceWithCalamityEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle your library. As many times as you choose, you may exile the top card of your library. If the total mana value of the cards exiled this way is 13 or less, you may cast any number of spells from among those cards without paying their mana costs";
    }

    private DanceWithCalamityEffect(DanceWithCalamityEffect effect) {
        super((OneShotEffect)effect);
    }

    public DanceWithCalamityEffect copy() {
        return new DanceWithCalamityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        while (player.getLibrary().hasCards()) {
            int totalMV = cards.getCards(game).stream().mapToInt(MageObject::getManaValue).sum();
            if (!player.chooseUse(this.outcome, "Exile the top card of your library?", "Current total mana value is " + totalMV, "Yes", "No", source, game)) break;
            Card card = player.getLibrary().getFromTop(game);
            player.moveCards(card, Zone.EXILED, source, game);
            cards.add(card);
        }
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        if (cards.getCards(game).stream().mapToInt(MageObject::getManaValue).sum() <= 13) {
            CardUtil.castMultipleWithAttributeForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
        }
        return true;
    }
}

