/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class DarigaazTheIgniterEffect
extends OneShotEffect {
    DarigaazTheIgniterEffect() {
        super(Outcome.Damage);
        this.staticText = "choose a color, then that player reveals their hand and {this} deals damage to the player equal to the number of cards of that color revealed this way";
    }

    private DarigaazTheIgniterEffect(DarigaazTheIgniterEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarigaazTheIgniterEffect copy() {
        return new DarigaazTheIgniterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceColor choice = new ChoiceColor(true);
        if (controller != null && controller.choose(this.outcome, (Choice)choice, game)) {
            game.informPlayers(controller.getLogName() + " chooses " + choice.getColor());
            Player damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (damagedPlayer != null) {
                damagedPlayer.revealCards("hand of " + damagedPlayer.getName(), damagedPlayer.getHand(), game);
                FilterCard filter = new FilterCard();
                filter.add((Predicate)new ColorPredicate(choice.getColor()));
                int damage = damagedPlayer.getHand().count(filter, source.getControllerId(), source, game);
                if (damage > 0) {
                    damagedPlayer.damage(damage, source.getSourceId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

