/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class DaringThiefSecondTarget
extends TargetPermanent {
    public DaringThiefSecondTarget() {
        super(StaticFilters.FILTER_OPPONENTS_PERMANENT);
        this.withTargetName("permanent an opponent controls that shares a card type with it");
    }

    private DaringThiefSecondTarget(DaringThiefSecondTarget target) {
        super((TargetPermanent)target);
    }

    public boolean canTarget(UUID id, Ability source, Game game) {
        Permanent ownPermanent = game.getPermanent(source.getFirstTarget());
        Permanent possiblePermanent = game.getPermanent(id);
        if (ownPermanent == null || possiblePermanent == null) {
            return false;
        }
        return super.canTarget(id, source, game) && ownPermanent.shareTypes((Card)possiblePermanent, game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Permanent ownPermanent = game.getPermanent(source.getFirstTarget());
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
            if (ownPermanent == null) {
                possibleTargets.add(permanent.getId());
                continue;
            }
            if (!permanent.shareTypes((Card)ownPermanent, game)) continue;
            possibleTargets.add(permanent.getId());
        }
        possibleTargets.removeIf(id -> ownPermanent != null && ownPermanent.getId().equals(id));
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public boolean chooseTarget(Outcome outcome, UUID playerId, Ability source, Game game) {
        return super.chooseTarget(Outcome.GainControl, playerId, source, game);
    }

    public DaringThiefSecondTarget copy() {
        return new DaringThiefSecondTarget(this);
    }
}

