/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DarkImpostorExileTargetEffect
extends OneShotEffect {
    DarkImpostorExileTargetEffect() {
        super(Outcome.Exile);
        this.staticText = "exile target creature";
    }

    private DarkImpostorExileTargetEffect(DarkImpostorExileTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarkImpostorExileTargetEffect copy() {
        return new DarkImpostorExileTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        return player.moveCardsToExile((Card)permanent, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
    }
}

