/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetSacrifice;

class DarkIntimationsEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("a creature or planeswalker");
    private static final FilterCard filterCard = new FilterCard("a creature or planeswalker card");

    public DarkIntimationsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent sacrifices a creature or planeswalker, then discards a card. You return a creature or planeswalker card from your graveyard to your hand, then draw a card";
    }

    private DarkIntimationsEffect(DarkIntimationsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarkIntimationsEffect copy() {
        return new DarkIntimationsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList perms = new ArrayList();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            TargetSacrifice target;
            player = game.getPlayer(playerId);
            if (player == null || !(target = new TargetSacrifice(filter)).canChoose(player.getId(), source, game)) continue;
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            perms.addAll(target.getTargets());
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            player.discardOne(false, false, source, game);
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filterCard);
        if (target.canChoose(source.getControllerId(), source, game) && controller.choose(Outcome.ReturnToHand, (Target)target, source, game)) {
            Card card = game.getCard(target.getFirstTarget());
            if (card == null) {
                return false;
            }
            controller.moveCards(card, Zone.HAND, source, game);
        }
        controller.drawCards(1, source, game);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
        filterCard.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

