/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.common.PreventNextDamageFromChosenSourceEffect;
import mage.constants.Duration;
import mage.filter.FilterSource;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.players.Player;

class DarkSpherePreventionEffect
extends PreventNextDamageFromChosenSourceEffect {
    private static final FilterSource filter = new FilterSource("source");

    public DarkSpherePreventionEffect() {
        super(Duration.EndOfTurn, true, filter);
        this.staticText = "The next time a source of your choice would deal damage to you this turn, prevent half that damage, rounded down";
    }

    private DarkSpherePreventionEffect(DarkSpherePreventionEffect effect) {
        super((PreventNextDamageFromChosenSourceEffect)effect);
    }

    public DarkSpherePreventionEffect copy() {
        return new DarkSpherePreventionEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        DamageEvent damageEvent = (DamageEvent)event;
        int damage = damageEvent.getAmount();
        if (controller == null || damage <= 0) {
            return false;
        }
        controller.damage((int)Math.ceil((double)damage / 2.0), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), damageEvent.getAppliedEffects());
        StringBuilder sb = new StringBuilder(sourceObject != null ? sourceObject.getLogName() : "");
        sb.append(": ").append(damage / 2).append(" damage prevented");
        sb.append(" from ").append(controller.getLogName());
        game.informPlayers(sb.toString());
        this.discard();
        return true;
    }
}

