/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;

class DarkSupplicantEffect
extends OneShotEffect {
    DarkSupplicantEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Search your graveyard, hand, and/or library for a card named Scion of Darkness and put it onto the battlefield. If you search your library this way, shuffle";
    }

    private DarkSupplicantEffect(DarkSupplicantEffect effect) {
        super((OneShotEffect)effect);
    }

    public DarkSupplicantEffect copy() {
        return new DarkSupplicantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInYourGraveyard target;
        Player controller = game.getPlayer(source.getControllerId());
        FilterCard filter = new FilterCard("card named Scion of Darkness");
        filter.add((Predicate)new NamePredicate("Scion of Darkness"));
        if (controller == null) {
            return false;
        }
        Card selectedCard = null;
        if (controller.chooseUse(Outcome.Benefit, "Search your graveyard for Scion of Darkness?", source, game)) {
            target = new TargetCardInYourGraveyard(1, 1, filter, true);
            if (controller.choose(this.outcome, (Cards)controller.getGraveyard(), (TargetCard)target, source, game)) {
                selectedCard = game.getCard(target.getFirstTarget());
            }
        }
        if (selectedCard == null && controller.chooseUse(Outcome.Benefit, "Search your hand for Scion of Darkness?", source, game)) {
            target = new TargetCardInHand(0, 1, filter);
            if (controller.choose(Outcome.PutCardInPlay, controller.getHand(), (TargetCard)target, source, game) && !target.getTargets().isEmpty()) {
                selectedCard = game.getCard(target.getFirstTarget());
            }
        }
        boolean librarySearched = false;
        if (selectedCard == null && controller.chooseUse(Outcome.Benefit, "Search your library for Scion of Darkness?", source, game)) {
            librarySearched = true;
            TargetCardInLibrary target2 = new TargetCardInLibrary(0, 1, filter);
            if (controller.searchLibrary(target2, source, game) && !target2.getTargets().isEmpty()) {
                selectedCard = game.getCard(target2.getFirstTarget());
            }
        }
        if (selectedCard != null) {
            controller.moveCards(selectedCard, Zone.BATTLEFIELD, source, game);
        }
        if (librarySearched) {
            controller.shuffleLibrary(source, game);
        }
        return true;
    }
}

