/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DauntlessBodyguardGainAbilityEffect
extends OneShotEffect {
    DauntlessBodyguardGainAbilityEffect() {
        super(Outcome.AddAbility);
        this.staticText = "The chosen creature gains indestructible until end of turn";
    }

    private DauntlessBodyguardGainAbilityEffect(DauntlessBodyguardGainAbilityEffect effect) {
        super((OneShotEffect)effect);
    }

    public DauntlessBodyguardGainAbilityEffect copy() {
        return new DauntlessBodyguardGainAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object chosenCreature = game.getState().getValue(CardUtil.getCardZoneString((String)"chosenCreature", (UUID)source.getSourceId(), (Game)game, (boolean)true));
        if (!(chosenCreature instanceof MageObjectReference)) {
            return false;
        }
        Permanent permanent = ((MageObjectReference)chosenCreature).getPermanent(game);
        if (permanent == null) {
            return false;
        }
        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

