/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.PreventAllDamageByAllPermanentsEffect;
import mage.abilities.effects.common.RegenerateTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.d.DawnCharmPredicate;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterSpell;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.target.Target;
import mage.target.TargetSpell;
import mage.target.common.TargetCreaturePermanent;

public final class DawnCharm
extends CardImpl {
    private static final FilterSpell filter = new FilterSpell("spell that targets you");

    public DawnCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{W}");
        this.getSpellAbility().addEffect((Effect)new PreventAllDamageByAllPermanentsEffect(Duration.EndOfTurn, true));
        Mode mode = new Mode((Effect)new RegenerateTargetEffect());
        mode.addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new CounterTargetEffect());
        mode.addTarget((Target)new TargetSpell(filter));
        this.getSpellAbility().addMode(mode);
    }

    private DawnCharm(DawnCharm card) {
        super((CardImpl)card);
    }

    public DawnCharm copy() {
        return new DawnCharm(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)new DawnCharmPredicate());
    }
}

