/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DawnOfANewAgeEffect
extends OneShotEffect {
    DawnOfANewAgeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "remove a hope counter from {this}. If you do, draw a card. Then if {this} has no hope counters on it, sacrifice it and you gain 4 life";
    }

    private DawnOfANewAgeEffect(DawnOfANewAgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null && controller != null) {
            int numCounters = permanent.getCounters(game).getCount(CounterType.HOPE);
            if (numCounters >= 1) {
                permanent.removeCounters(CounterType.HOPE.getName(), 1, source, game);
                controller.drawCards(1, source, game);
                --numCounters;
            }
            if (numCounters == 0) {
                permanent.sacrifice(source, game);
                controller.gainLife(4, game, source);
            }
            return true;
        }
        return false;
    }

    public DawnOfANewAgeEffect copy() {
        return new DawnOfANewAgeEffect(this);
    }
}

