/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.token.DragonToken2;
import mage.players.Player;
import mage.util.CardUtil;

class DayOfTheDragonsEntersEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("all creatures you control");

    public DayOfTheDragonsEntersEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all creatures you control. Then create that many 5/5 red Dragon creature tokens with flying";
    }

    private DayOfTheDragonsEntersEffect(DayOfTheDragonsEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            HashSet toExile = new HashSet();
            toExile.addAll(game.getBattlefield().getAllActivePermanents(filter, source.getControllerId(), game));
            if (!toExile.isEmpty()) {
                UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
                controller.moveCardsToExile(toExile, source, game, true, exileId, sourceObject.getIdName());
                DragonToken2 token = new DragonToken2();
                token.putOntoBattlefield(toExile.size(), game, source, source.getControllerId());
            }
            return true;
        }
        return false;
    }

    public DayOfTheDragonsEntersEffect copy() {
        return new DayOfTheDragonsEntersEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

