/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.util.CardUtil;

class DayOfTheDragonsLeavesEffect
extends OneShotEffect {
    public DayOfTheDragonsLeavesEffect() {
        super(Outcome.Neutral);
        this.staticText = "Then return the exiled cards to the battlefield under your control";
    }

    private DayOfTheDragonsLeavesEffect(DayOfTheDragonsLeavesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null) {
            ExileZone exile;
            int zoneChangeCounter = source.getStackMomentSourceZCC();
            if (zoneChangeCounter > 0 && !(sourceObject instanceof PermanentToken)) {
                --zoneChangeCounter;
            }
            if ((exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)zoneChangeCounter))) != null) {
                controller.moveCards((Cards)exile, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }

    public DayOfTheDragonsLeavesEffect copy() {
        return new DayOfTheDragonsLeavesEffect(this);
    }
}

