/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.choices.Choice;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DayOfTheMoonEffect
extends OneShotEffect {
    DayOfTheMoonEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature card name, then goad all creatures with a name chosen for {this}";
    }

    private DayOfTheMoonEffect(DayOfTheMoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public DayOfTheMoonEffect copy() {
        return new DayOfTheMoonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Choice cardChoice = ChooseACardNameEffect.TypeOfName.CREATURE_NAME.makeChoiceObject();
        player.choose(this.outcome, cardChoice, game);
        String cardName = cardChoice.getChoice();
        List<String> names = DayOfTheMoonEffect.getOrSetValue(game, source);
        names.add(cardName);
        names.removeIf(Objects::isNull);
        if (names.isEmpty()) {
            return true;
        }
        game.informPlayers(CardUtil.getSourceLogName((Game)game, (Ability)source) + ": " + player.getName() + ", chosen name: [" + cardName + ']');
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.addInfo("NAMED_CARD", CardUtil.addToolTipMarkTags((String)("Chosen names: " + CardUtil.concatWithAnd((List)names))), game));
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add(Predicates.or((Iterable)names.stream().map(NamePredicate::new).collect(Collectors.toSet())));
        game.addEffect(new GoadTargetEffect().setTargetPointer((TargetPointer)new FixedTargets((Collection)game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game), game)), source);
        return true;
    }

    private static List<String> getOrSetValue(Game game, Ability source) {
        String key = "DayOfTheMoon_" + source.getControllerId() + '_' + source.getStackMomentSourceZCC();
        List list = (List)game.getState().getValue(key);
        if (list != null) {
            return list;
        }
        return (List)game.getState().setValue(key, new ArrayList());
    }
}

