/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.d.AuraAttachedPredicate;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class DaybreakCoronet
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature with another Aura attached to it");

    public DaybreakCoronet(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{W}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent(filter);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(3, 3, Duration.WhileOnBattlefield));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)FirstStrikeAbility.getInstance(), AttachmentType.AURA).setText("and has first strike"));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)VigilanceAbility.getInstance(), AttachmentType.AURA).setText(", vigilance"));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)LifelinkAbility.getInstance(), AttachmentType.AURA).setText(", and lifelink"));
        this.addAbility((Ability)ability);
    }

    private DaybreakCoronet(DaybreakCoronet card) {
        super((CardImpl)card);
    }

    public DaybreakCoronet copy() {
        return new DaybreakCoronet(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AuraAttachedPredicate.instance);
    }
}

