/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DazzlingSphinxEffect
extends OneShotEffect {
    DazzlingSphinxEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player exiles cards from the top of their library until they exile an instant or sorcery card. You may cast that card without paying its mana cost. Then that player puts the exiled cards that weren't cast this way on the bottom of their library in a random order";
    }

    private DazzlingSphinxEffect(DazzlingSphinxEffect effect) {
        super((OneShotEffect)effect);
    }

    public DazzlingSphinxEffect copy() {
        return new DazzlingSphinxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Card card : opponent.getLibrary().getCards(game)) {
            cards.add(card);
            opponent.moveCards(card, Zone.EXILED, source, game);
            if (!card.isInstantOrSorcery(game)) continue;
            CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card);
            break;
        }
        cards.retainZone(Zone.EXILED, game);
        opponent.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

