/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInYourGraveyard;

class DeadlyBrewEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreatureOrPlaneswalkerPermanent("creature or planeswalker you control");

    DeadlyBrewEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player sacrifices a creature or planeswalker of their choice. If you sacrificed a permanent this way, you may return another permanent card from your graveyard to your hand";
    }

    private DeadlyBrewEffect(DeadlyBrewEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeadlyBrewEffect copy() {
        return new DeadlyBrewEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Permanent> toSacrifice = new ArrayList<Permanent>();
        Permanent yours = null;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            if (!target.canChoose(playerId, source, game)) continue;
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            if (permanent.isControlledBy(source.getControllerId())) {
                yours = permanent;
                continue;
            }
            toSacrifice.add(permanent);
        }
        for (Permanent permanent : toSacrifice) {
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        CardsImpl yourGrave = new CardsImpl((Collection)controller.getGraveyard());
        yourGrave.removeIf(uuid -> !game.getCard(uuid).isPermanent(game));
        if (yours == null || !yours.sacrifice(source, game)) {
            return true;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_PERMANENT, true);
        controller.choose(this.outcome, (Cards)yourGrave, (TargetCard)target, source, game);
        Card card = controller.getGraveyard().get(target.getFirstTarget(), game);
        if (card != null) {
            controller.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

