/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class DeafeningSilenceWatcher
extends Watcher {
    private final Map<UUID, Integer> spellsCastByPlayerThisTurnNonCreature = new HashMap<UUID, Integer>();

    DeafeningSilenceWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || spell.isCreature(game)) {
            return;
        }
        UUID playerId = event.getPlayerId();
        if (playerId != null) {
            this.spellsCastByPlayerThisTurnNonCreature.putIfAbsent(playerId, 0);
            this.spellsCastByPlayerThisTurnNonCreature.compute(playerId, (k, v) -> v + 1);
        }
    }

    public void reset() {
        super.reset();
        this.spellsCastByPlayerThisTurnNonCreature.clear();
    }

    public int spellsCastByPlayerThisTurnNonCreature(UUID playerId) {
        return this.spellsCastByPlayerThisTurnNonCreature.getOrDefault(playerId, 0);
    }
}

