/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Duration;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class DeathFrenzyDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    public DeathFrenzyDelayedTriggeredAbility() {
        super((Effect)new GainLifeEffect(1), Duration.EndOfTurn, false);
    }

    private DeathFrenzyDelayedTriggeredAbility(DeathFrenzyDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget() != null && StaticFilters.FILTER_PERMANENT_CREATURES.match(zEvent.getTarget(), this.controllerId, (Ability)this, game);
    }

    public DeathFrenzyDelayedTriggeredAbility copy() {
        return new DeathFrenzyDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature dies this turn, you gain 1 life.";
    }
}

