/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FearAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.LandwalkAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AbilityWord;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

public final class DeathMaskDuplicant
extends CardImpl {
    public DeathMaskDuplicant(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{7}");
        this.subtype.add((Object)SubType.SHAPESHIFTER);
        this.power = new MageInt(5);
        this.toughness = new MageInt(5);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new ExileTargetEffect().setToSourceExileZone(true), (Cost)new GenericManaCost(1));
        ability.addTarget((Target)new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD));
        ability.setAbilityWord(AbilityWord.IMPRINT);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new DeathMaskDuplicantEffect()));
    }

    private DeathMaskDuplicant(DeathMaskDuplicant card) {
        super((CardImpl)card);
    }

    public DeathMaskDuplicant copy() {
        return new DeathMaskDuplicant(this);
    }

    static class DeathMaskDuplicantEffect
    extends ContinuousEffectImpl {
        public DeathMaskDuplicantEffect() {
            super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
            this.addDependedToType(DependencyType.AddingAbility);
            this.staticText = "As long as a card exiled with {this} has flying, {this} has flying. The same is true for fear, first strike, double strike, haste, landwalk, protection, and trample";
        }

        private DeathMaskDuplicantEffect(DeathMaskDuplicantEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public boolean apply(Game game, Ability source) {
            Permanent sourceObject = game.getPermanent(source.getSourceId());
            if (sourceObject == null) {
                return false;
            }
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                ExileZone exileZone;
                Player player = game.getPlayer(playerId);
                if (player == null || (exileZone = game.getState().getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourceObject.getZoneChangeCounter(game)))) == null || exileZone.isEmpty()) continue;
                for (UUID cardId : exileZone) {
                    Card card = game.getCard(cardId);
                    if (card == null || !card.isCreature(game)) continue;
                    for (Ability ability : card.getAbilities(game)) {
                        if (ability instanceof MageSingleton) {
                            if (!(ability instanceof FlyingAbility) && !(ability instanceof FearAbility) && !(ability instanceof FirstStrikeAbility) && !(ability instanceof DoubleStrikeAbility) && !(ability instanceof HasteAbility) && !(ability instanceof TrampleAbility)) continue;
                            sourceObject.addAbility(ability, source.getSourceId(), game);
                            continue;
                        }
                        if (!(ability instanceof ProtectionAbility) && !(ability instanceof LandwalkAbility)) continue;
                        sourceObject.addAbility(ability, source.getSourceId(), game);
                    }
                }
            }
            return true;
        }

        public DeathMaskDuplicantEffect copy() {
            return new DeathMaskDuplicantEffect(this);
        }
    }
}

