/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.cards.Card;
import mage.game.Game;
import mage.players.Player;

enum DeathSparkCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean nextCard = false;
        for (Card card : controller.getGraveyard().getCards(game)) {
            if (nextCard) {
                return card.isCreature(game);
            }
            if (!card.getId().equals(source.getSourceId())) continue;
            nextCard = true;
        }
        return false;
    }

    public String toString() {
        return "this card is in your graveyard with a creature card directly above it";
    }
}

