/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DeathsCaressEffect
extends OneShotEffect {
    DeathsCaressEffect() {
        super(Outcome.GainLife);
        this.staticText = "If that creature was a Human, you gain life equal to its toughness";
    }

    private DeathsCaressEffect(DeathsCaressEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathsCaressEffect copy() {
        return new DeathsCaressEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent creature = (Permanent)game.getLastKnownInformation(source.getFirstTarget(), Zone.BATTLEFIELD);
        if (player != null && creature != null && creature.hasSubtype(SubType.HUMAN, game)) {
            player.gainLife(creature.getToughness().getValue(), game, source);
            return true;
        }
        return false;
    }
}

