/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class DebtToTheKamiExileEnchantmentEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("enchantment you control");

    public DebtToTheKamiExileEnchantmentEffect() {
        super(Outcome.Exile);
        this.staticText = "Target opponent exiles an enchantment they control";
    }

    private DebtToTheKamiExileEnchantmentEffect(DebtToTheKamiExileEnchantmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public DebtToTheKamiExileEnchantmentEffect copy() {
        return new DebtToTheKamiExileEnchantmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        TargetControlledPermanent target = new TargetControlledPermanent(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return player.moveCards((Card)permanent, Zone.EXILED, source, game);
    }

    static {
        filter.add((Predicate)CardType.ENCHANTMENT.getPredicate());
    }
}

