/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DecreeOfAnnihilationEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    DecreeOfAnnihilationEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all artifacts, creatures, and lands from the battlefield, all cards from all graveyards, and all cards from all hands";
    }

    private DecreeOfAnnihilationEffect(DecreeOfAnnihilationEffect effect) {
        super((OneShotEffect)effect);
    }

    public DecreeOfAnnihilationEffect copy() {
        return new DecreeOfAnnihilationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            cards.add((Card)permanent);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.addAll((Collection)player.getHand());
            cards.addAll((Collection)player.getGraveyard());
        }
        return controller.moveCards((Cards)cards, Zone.EXILED, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

