/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class DeepWaterReplacementEffect
extends ReplacementEffectImpl {
    DeepWaterReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.staticText = "Until end of turn, if you tap a land you control for mana, it produces {U} instead of any other type";
    }

    private DeepWaterReplacementEffect(DeepWaterReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DeepWaterReplacementEffect copy() {
        return new DeepWaterReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        mana.setToMana(Mana.BlueMana((int)mana.count()));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game) && permanent.isControlledBy(source.getControllerId());
    }
}

