/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class DeeprootWayfinderEffect
extends OneShotEffect {
    DeeprootWayfinderEffect() {
        super(Outcome.Benefit);
        this.staticText = "surveil 1, then you may return a land card from your graveyard to the battlefield tapped";
    }

    private DeeprootWayfinderEffect(DeeprootWayfinderEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeeprootWayfinderEffect copy() {
        return new DeeprootWayfinderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.surveil(1, source, game);
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND_A);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

