/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class DefensiveManeuversEffect
extends OneShotEffect {
    DefensiveManeuversEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Creatures of the creature type of your choice get +0/+4 until end of turn.";
    }

    private DefensiveManeuversEffect(DefensiveManeuversEffect effect) {
        super((OneShotEffect)effect);
    }

    public DefensiveManeuversEffect copy() {
        return new DefensiveManeuversEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (player == null || sourceObject == null) {
            return false;
        }
        ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
        SubType subType = null;
        if (player.choose(this.outcome, (Choice)choice, game)) {
            subType = SubType.byDescription((String)choice.getChoiceKey());
        }
        if (subType == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)subType.getPredicate());
        game.addEffect((ContinuousEffect)new BoostAllEffect(0, 4, Duration.EndOfTurn, filter, false), source);
        return true;
    }
}

