/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.RemoveCounterTargetEffect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;

class DefiantGreatmawTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("another target creature");

    DefiantGreatmawTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new RemoveCounterTargetEffect(CounterType.M1M1.createInstance(1)), false);
        this.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
    }

    private DefiantGreatmawTriggeredAbility(DefiantGreatmawTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getData().equals(CounterType.M1M1.getName()) && this.isControlledBy(event.getPlayerId()) && event.getTargetId().equals(this.getSourceId());
    }

    public DefiantGreatmawTriggeredAbility copy() {
        return new DefiantGreatmawTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you put one or more -1/-1 counters on {this}, remove a -1/-1 counter from another target creature you control.";
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

