/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class DelightedHalflingWatcher
extends Watcher {
    private final Set<MageObjectReference> spells = new HashSet<MageObjectReference>();
    private final UUID originalId;

    public DelightedHalflingWatcher(UUID originalId) {
        super(WatcherScope.CARD);
        this.originalId = originalId;
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.MANA_PAID && event.getData() != null && event.getData().equals(this.originalId.toString()) && event.getTargetId() != null) {
            this.spells.add(new MageObjectReference(game.getObject(event.getTargetId()), game));
        }
    }

    public boolean spellCantBeCountered(MageObjectReference mor) {
        return this.spells.contains(mor);
    }

    public void reset() {
        super.reset();
        this.spells.clear();
    }
}

