/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DeliriumEffect
extends OneShotEffect {
    DeliriumEffect() {
        super(Outcome.Damage);
        this.staticText = "that creature deals damage equal to its power to the player";
    }

    private DeliriumEffect(DeliriumEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature != null) {
            int amount = creature.getPower().getValue();
            Player controller = game.getPlayer(creature.getControllerId());
            if (controller != null) {
                controller.damage(amount, creature.getId(), source, game);
                return true;
            }
        }
        return false;
    }

    public DeliriumEffect copy() {
        return new DeliriumEffect(this);
    }
}

