/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DelneyStreetwiseLookoutEffect
extends ReplacementEffectImpl {
    DelneyStreetwiseLookoutEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if an ability of a creature you control with power 2 or less triggers, that ability triggers an additional time";
    }

    private DelneyStreetwiseLookoutEffect(DelneyStreetwiseLookoutEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DelneyStreetwiseLookoutEffect copy() {
        return new DelneyStreetwiseLookoutEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId()) && permanent.getPower().getValue() <= 2;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

