/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DelverOfSecretsEffect
extends OneShotEffect {
    public DelverOfSecretsEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. You may reveal that card. If an instant or sorcery card is revealed this way, transform {this}";
    }

    private DelverOfSecretsEffect(DelverOfSecretsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DelverOfSecretsEffect copy() {
        return new DelverOfSecretsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.getLibrary().hasCards()) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(card);
        player.lookAtCards(CardUtil.getSourceLogName((Game)game, (Ability)source), (Cards)cards, game);
        if (!player.chooseUse(Outcome.DrawCard, "Reveal the top card of your library?", source, game)) {
            return false;
        }
        player.revealCards(source, (Cards)cards, game);
        if (card.isInstantOrSorcery(game)) {
            Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.transform(source, game));
        }
        return true;
    }
}

