/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.cards.d.DemonOfFatesDesignPayLifeCost;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class DemonOfFatesDesignWatcher
extends Watcher {
    private final Set<MageObjectReference> usedFrom = new HashSet<MageObjectReference>();

    public DemonOfFatesDesignWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getSpell(event.getTargetId())) != null) {
            for (Cost cost : spell.getStackAbility().getCosts()) {
                if (!(cost instanceof DemonOfFatesDesignPayLifeCost)) continue;
                this.usedFrom.add(((DemonOfFatesDesignPayLifeCost)cost).getMor());
            }
        }
    }

    public void reset() {
        super.reset();
        this.usedFrom.clear();
    }

    public boolean canAbilityBeUsed(Game game, Ability source, MageObjectReference mor) {
        return game.isActivePlayer(source.getControllerId()) && !this.usedFrom.contains(mor);
    }
}

