/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DemonicJunkerEffect
extends OneShotEffect {
    DemonicJunkerEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "for each player, destroy up to one target creature that player controls. If a creature you controlled was destroyed this way, put two +1/+1 counters on this Vehicle";
    }

    public DemonicJunkerEffect(DemonicJunkerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DemonicJunkerEffect copy() {
        return new DemonicJunkerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean giveCounters = false;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent vehicle;
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            if (permanent.destroy(source, game, false)) {
                giveCounters = permanent.getControllerId().equals(source.getControllerId());
            }
            if (!giveCounters || (vehicle = game.getPermanent(source.getSourceId())) == null) continue;
            vehicle.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
        }
        return true;
    }
}

