/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DemonlordBelzenlokEffect
extends OneShotEffect {
    DemonlordBelzenlokEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile a nonland card, then put that card into your hand. If the card's mana value is 4 or greater, repeat this process. {this} deals 1 damage to you for each card put into your hand this way";
    }

    private DemonlordBelzenlokEffect(DemonlordBelzenlokEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller == null || permanent == null) {
            return false;
        }
        boolean cont = true;
        int addedToHand = 0;
        while (controller.getLibrary().hasCards() && cont) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card == null) continue;
            controller.moveCards(card, Zone.EXILED, source, game);
            if (card.isLand(game)) continue;
            if (card.getManaValue() < 4) {
                cont = false;
            }
            controller.moveCards(card, Zone.HAND, source, game);
            ++addedToHand;
        }
        controller.damage(addedToHand, source.getSourceId(), source, game);
        return true;
    }

    public DemonlordBelzenlokEffect copy() {
        return new DemonlordBelzenlokEffect(this);
    }
}

