/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class DeniedEffect
extends OneShotEffect {
    DeniedEffect() {
        super(Outcome.Detriment);
        this.staticText = "Choose a card name, then target spell's controller reveals their hand. If a card with the chosen name is revealed this way, counter that spell";
    }

    private DeniedEffect(DeniedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell targetSpell = game.getStack().getSpell(source.getFirstTarget());
        if (targetSpell == null) {
            return true;
        }
        Player player = game.getPlayer(targetSpell.getControllerId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (player != null && cardName != null) {
            player.revealCards("Denied!", player.getHand(), game, true);
            for (Card card : player.getHand().getCards(game)) {
                if (card == null || !CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
                game.getStack().counter(targetSpell.getId(), source, game);
                break;
            }
            return true;
        }
        return false;
    }

    public DeniedEffect copy() {
        return new DeniedEffect(this);
    }
}

