/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.MulticoloredPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

class DepopulateEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    DepopulateEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player who controls a multicolored creature draws a card";
    }

    private DepopulateEffect(DepopulateEffect effect) {
        super((OneShotEffect)effect);
    }

    public DepopulateEffect copy() {
        return new DepopulateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set players = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game).stream().map(Controllable::getControllerId).collect(Collectors.toSet());
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player;
            if (!players.contains(playerId) || (player = game.getPlayer(playerId)) == null) continue;
            player.drawCards(1, source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)MulticoloredPredicate.instance);
    }
}

